#!/usr/bin/env bash
# 从dm_install_list_v2表在reyun分区里的com.eg.android.AlipayGphone设备拉出来到某个路径里（天级别更新）, 后续需要把这个人群包入rtdmp，命名为com.eg.android.AlipayGphone_reyun
# 获取下面这2个包名在business=btop(topon）和reyun（热云）的设备入人群包数据库  com.taobao.litetao  com.ss.android.ugc.aweme
# 人群包名称可以叫 com.taobao.litetao_reyun com.ss.android.ugc.aweme_reyun com.taobao.litetao_btop com.ss.android.ugc.aweme_btop

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

business1="reyun"
INPUT_PATH1="${DM_INSTALL_LIST}_v2/${dt_dash_today}/${business1}"
check_await ${INPUT_PATH1}/_SUCCESS

business2="btop"
INPUT_PATH2="${DM_INSTALL_LIST}_v2/${dt_dash_today}/${business2}"
check_await ${INPUT_PATH2}/_SUCCESS

OUTPUT_PATH1="${RTDMP_COM_EG_ANDROID_ALIPAYGPHONE_REYUN_PATH}/${dt_dash_today}/"
OUTPUT_PATH2="${RTDMP_COM_TAOBAO_LITETAO_REYUN_PATH}/${dt_dash_today}/"
OUTPUT_PATH3="${RTDMP_COM_SS_ANDROID_UGC_AWEME_REYUN_PATH}/${dt_dash_today}/"
OUTPUT_PATH4="${RTDMP_COM_TAOBAO_LITETAO_BTOP_PATH}/${dt_dash_today}/"
OUTPUT_PATH5="${RTDMP_COM_SS_ANDROID_UGC_AWEME_BTOP_PATH}/${dt_dash_today}/"
hadoop fs -rm -r "${OUTPUT_PATH1}"
hadoop fs -rm -r "${OUTPUT_PATH2}"
hadoop fs -rm -r "${OUTPUT_PATH3}"
hadoop fs -rm -r "${OUTPUT_PATH4}"
hadoop fs -rm -r "${OUTPUT_PATH5}"

spark-submit --class mobvista.dmp.datasource.dm.ComEgAndroidAlipayGphoneReyun \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.network.timeout=720s \
 --files ${HIVE_SITE_PATH} \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 6g  --executor-cores 6  --num-executors 20 \
 ../../${JAR} -dt_today ${dt_today}    -output1 ${OUTPUT_PATH1}  -output2 ${OUTPUT_PATH2}  -output3 ${OUTPUT_PATH3}  -output4 ${OUTPUT_PATH4}  -output5 ${OUTPUT_PATH5} \
  -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi
