# !/bin/sh
source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
yesday=$(date +"%Y%m%d" -d "-2 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

OUTPUT_PATH="${ODS_DMP_EVENT_TAG}/${date_path}"
# dwh.ods_dmp_event_org
hadoop fs -rmr "${OUTPUT_PATH}/3s"
hadoop fs -rmr "${OUTPUT_PATH}/ss"
hadoop fs -rmr "${OUTPUT_PATH}/allpb"

spark-submit --class mobvista.dmp.datasource.event_tag.DmpEventTag \
      --conf spark.network.timeout=720s \
      --conf spark.sql.shuffle.partitions=600 \
      --conf spark.default.parallelism=600 \
      --conf spark.sql.broadcastTimeout=600 \
      --files ${HIVE_SITE_PATH} \
      --jars /data/hadoop-alternative/hive/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
      --master yarn --deploy-mode cluster   --executor-cores 3 --executor-memory 6G --num-executors 20 \
      ../${JAR} \
      -today ${date} -output  ${OUTPUT_PATH}  -coalesce 600

mount_partition "ods_dmp_event_tag" "dt='${date}',business='allpb'" "$OUTPUT_PATH/allpb"
mount_partition "ods_dmp_event_tag" "dt='${date}',business='3s'" "$OUTPUT_PATH/3s"
mount_partition "ods_dmp_event_tag" "dt='${date}',business='ss'" "$OUTPUT_PATH/ss"


mount_partition "ods_dmp_event_tag" "dt='${date}',business='other'" "$OUTPUT_PATH/other"
mount_partition "ods_dmp_event_tag_daily_others" "dt='${date}'" "$ODS_DMP_EVENT_DAILY_OTHERS/$date_path"


export HIVE_CONF_DIR=/data/azkaban-hadoop/command-home/hive-offline/conf

hive -v  -e "insert overwrite table dwh.ods_dmp_event_tag partition(dt='${date}',business='other')
select
  coalesce(t1.device_id,t2.device_id) device_id,
  coalesce(t1.uuid,t2.uuid) uuid,
  coalesce(t1.platform,t2.platform) platform,
  coalesce(t1.device_type,t2.device_type) device_type,
  coalesce(t1.country,t2.country) country,
  coalesce(t1.package_name,t2.package_name) package_name,
  coalesce(t1.first_tag,t2.first_tag) first_tag,
  coalesce(t1.second_tag,t2.second_tag) second_tag,
  coalesce(t1.behavior_tag,t2.behavior_tag) behavior_tag,
  coalesce(t1.update_date,t2.update_date) behavior_tag
  from (select device_id,uuid,platform,device_type,country,package_name,first_tag,second_tag,behavior_tag,update_date from dwh.ods_dmp_event_tag_daily_others where dt ='${date}') t1
  full join (select device_id,uuid,platform,device_type,country,package_name,first_tag,second_tag,behavior_tag,update_date from dwh.ods_dmp_event_tag where dt ='${yesday}' and business = 'other') t2
  on(t1.device_id = t2.device_id) "

if [ $? -ne 0 ]; then
    exit 255
fi



# hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS

