#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : dsp_profile_daily.sh
# @author: chao.wu
# @date  : 16-12-02
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_ADN_DSP_PATH="$ADN_DSP_PATH/$year/$month/$day"
OUTPUT_PATH="$DMP_ADN_DSP_DEVICE_IDS/$year/$month/$day"

hadoop fs -rm -r ${OUTPUT_PATH}/*
hadoop jar ../${JAR} mobvista.dmp.datasource.dsp.mapreduce.DspDeviceIdsMR \
    -Dtask.date="$year-$month-$day" \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_DSP_PATH" "$OUTPUT_PATH" || exit 1

mount_partition "etl_dsp_profile_daily" "yr='$year', mt='$month', dt='$day' " "$OUTPUT_PATH"

echo "[Adn_Dsp profile daily Tag End!]"


