#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : ga_revenue_tag.sh
# @author: houying
# @date  : 16-10-24
# # # # # # # # # # # # # # # # # # # # # # 

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_PATH_DAILY="$GA_DAILY_PATH/${year}/$month/$day"
INPUT_PATH_REVENUE=$(get_recently_dir "$REVENUE_PATH" "$YESTERDAY" "")
OUTPUT_PATH="$REVENUE_PATH/$year/$month/$day"

echo "
INPUT_PATH_DAILY=$INPUT_PATH_DAILY
INPUT_PATH_REVENUE=$INPUT_PATH_REVENUE
OUTPUT_PATH=$OUTPUT_PATH
"

hadoop fs -rm ${OUTPUT_PATH}/*
hadoop jar ../${JAR} mobvista.dmp.datasource.ga.mapreduce.GaRevenueMR \
     -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
     "$INPUT_PATH_REVENUE" "$INPUT_PATH_DAILY" "$OUTPUT_PATH" || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi

mount_partition "dm_ga_revenue" "year='${year}',month='${month}',day='${day}'" "$OUTPUT_PATH" || exit 1

echo "[GA Revenue End!]"
