#!/bin/bash
source ./common/tools.sh

today=${ScheduleTime:-$1}

echo "ScheduleTime=$ScheduleTime"
echo "toady=$today"

date_path=$(date +%Y/%m/%d -d "-1 day $today")
player_part_path=$(date +%Y%m%d -d "-1 day $today")
date_str_undline=$(date +%Y_%m_%d -d "-1 day $today")
date_str_undline_old=$(date +%Y_%m_%d -d "-3 day $today")
date_str_midline=$(date +%Y-%m-%d -d "-1 day $today")

HIVE_CMD=$(hive_func)

$HIVE_CMD -v -hivevar prefix=$date_path -hivevar date_str_undline=$date_str_undline -hivevar date_str_undline_old=$date_str_undline_old -hivevar date_str_midline=$date_str_midline -f player_checkpoint.sql

if [ $? -ne 0 ]; then
  exit 255
fi

for file in $(hadoop fs -ls s3://mob-emr-test/dataplatform/emr/${date_path}/*/ | grep -v "Found" | awk -F'/' '{print $9"/"$10}'); do
  line="aws s3api put-object-acl --acl bucket-owner-full-control --bucket mob-emr-test --key dataplatform/emr/${date_path}/${file}"
  echo ${line}
  eval ${line}
done

for file in $(hadoop fs -ls s3://mob-emr-test/dataplatform/emr/player/${player_part_path}/ | grep -v "Found" | awk -F'/' '{print $8}'); do
  line="aws s3api put-object-acl --acl bucket-owner-full-control --bucket mob-emr-test --key dataplatform/emr/player/${player_part_path}/${file}"
  echo ${line}
  eval ${line}
done

if [ $? -ne 0 ]; then
  exit 255
fi

hadoop fs -touchz s3://mob-emr-test/dataplatform/emr/${date_path}/player_checkpoint/_SUCCESS

aws s3api put-object-acl --acl bucket-owner-full-control --bucket mob-emr-test --key dataplatform/emr/${date_path}/player_checkpoint/_SUCCESS
