#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-08-28 18:06:59
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")

date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

DSP_USER_INFO_INPUT="${ODS_DMP_USER_INFO}/${date_path}/dsp_req"
# ADN_USER_INFO_INPUT="${ODS_DMP_USER_INFO}/${date_path}/adn_request"
# ALI_USER_INFO_INPUT="${ODS_DMP_USER_INFO}/${date_path}/ali"
# BTOP_USER_INFO_INPUT="${ODS_DMP_USER_INFO}/${date_path}/btop"

check_await ${DSP_USER_INFO_INPUT}/_SUCCESS
# check_await ${ADN_USER_INFO_INPUT}/_SUCCESS
# check_await ${ALI_USER_INFO_INPUT}/_SUCCESS
# check_await ${BTOP_USER_INFO_INPUT}/_SUCCESS

sleep 60

OUTPUT_PATH="${IQiYi_LAHUO_DAILY_PATH}/$date_path"

spark-submit --class mobvista.dmp.datasource.iqiyi.IQiYiLaHuoDaily \
     --name "IQiYiLaHuoDaily.${LOG_TIME}" \
     --conf spark.network.timeout=720s \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 50 \
     ../${JAR} -date ${LOG_TIME} -days 7 -output ${OUTPUT_PATH}

if [[ $? -ne 0 ]];then
  exit 255
fi