#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2020-09-10 16:38:51
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y-%m-%d")

if [[ ! -d "/home/hadoop/wangjf" ]]; then
  mkdir /home/hadoop/wangjf

  cd /home/hadoop/wangjf/

  hdfs dfs -get s3://mob-emr-test/wangjf/data/pem/dataplatform_cn.pem .

  chmod 600 dataplatform_cn.pem
fi

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.iqiyi.IQiYiRequest"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]]; then
  exit 255
fi

fors=700

concurrent=10000

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "/root/workspace/exec_iqiyi_request.sh ${fors} ${concurrent} ${LOG_TIME} >/root/workspace/exec_iqiyi_request.log &"

if [[ $? -ne 0 ]]; then
  exit 255
fi

sleep $((fors * 50))

shell=" -cp /root/workspace/DMP-1.0.3-jar-with-dependencies.jar mobvista.dmp.datasource.iqiyi.IQiYiRequest"

ssh -o "StrictHostKeyChecking no" -i /home/hadoop/wangjf/dataplatform_cn.pem -l root 182.92.177.185 "sh -x /root/workspace/check_process.sh '${shell}'"

if [[ $? -ne 0 ]]; then
  exit 255
fi
