#!/bin/bash

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

date=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")

business='mopub_dealerid'
INPUT_INSTALL_PATH="${DM_INSTALL_LIST}/$year/$month/$day/${business}"
INPUT_APP_TAG_PATH="${APP_TAG_PATH}/$year/$month/$day"

OUTPUT_PATH="${DM_INTEREST_PATH}/${year}/${month}/${day}/${business}"

check_await "${INPUT_APP_TAG_PATH}/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num ${INPUT_INSTALL_PATH})

hadoop fs -rm -r ${OUTPUT_PATH}
hadoop jar ../${JAR} mobvista.dmp.common.InterestDeviceDistinctMR \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dmapred.max.split.size=536870912 \
    -Dmapred.min.split.size.per.node=536870912 \
    -Dmapred.min.split.size.per.rack=536870912 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INPUT_APP_TAG_PATH}/part-r-00000" "${INPUT_INSTALL_PATH}" "${OUTPUT_PATH}" "mopub_dealerid interest job" || exit 1


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_interest_tag" "year='$year', month='$month', day='$day', business='${business}'" "$OUTPUT_PATH"

echo "[3s postback Interest Tag End!]"
