#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime:-$1}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +"%Y/%m/%d/" -d "-1 day $today")

INPUT_REGION_DSP="${ETL_DSP_REQ_DAILY}/$date_path"

check_await ${INPUT_REGION_DSP}/_SUCCESS

INPUT_REGION_ADN="$ETL_ADN_REQUEST_SDK_DAILY/$date_path"

check_await ${INPUT_REGION_ADN}/_SUCCESS

OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/device_region_daily/${date_path}"

spark-submit --class mobvista.dmp.datasource.rtdmp.DeviceRegionCalc \
     --name "DeviceRegionCalc.wangjf.${date}" \
     --conf spark.sql.shuffle.partitions=200 \
     --conf spark.default.parallelism=200 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --jars ${SPARK_HOME}/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 50 \
     ../${JAR} -date ${date} -output ${OUTPUT}

if [[ $? -ne 0 ]]; then
    exit 255
fi