#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime}

date_time=$(date +"%Y-%m-%d %H" -d "-1 hour $today")

date_path=$(date +%Y/%m/%d/%H -d "-1 hour $today")

INPUT="s3://mob-emr-test/dataplatform/rtdmp_deal/${date_path}/"

if hadoop fs -ls ${INPUT} >/dev/null 2>&1; then
  hadoop fs -touchz ${INPUT}/_SUCCESS
else
  hadoop fs -mkdir -p ${INPUT}
  hadoop fs -touchz ${INPUT}/_SUCCESS
fi

if [[ $? -ne 0 ]]; then
  exit 255
fi
