#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime}

date_time=$(date +"%Y%m%d%H" -d "-1 hour $today")

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="audience_merge"

spark-submit --class mobvista.dmp.datasource.rtdmp.RTDmpMergeCK \
  --name "RTDmpMergeCK.wangjf.${date_time}" \
  --conf spark.sql.shuffle.partitions=1000 \
  --conf spark.default.parallelism=1000 \
  --conf spark.kryoserializer.buffer.max=256m \
  --conf spark.speculation=false \
  --conf spark.speculation.quantile=0.9 \
  --conf spark.speculation.multiplier=1.3 \
  --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
  --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g --executor-cores 5 --num-executors 10 \
  ../${JAR} -date_time "${date_time}" -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]]; then
  exit 255
fi
