#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime}
date_path=$(date +%Y/%m/%d -d "-1 day $today")

INPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/tmp/rtdmp_tmp_package_name/cn_good_channel/${date_path}"

audience_names="adx_goodreq7 sdk_goodreq7 sdk_wangzhuan_goodreq7"
for audience_name in ${audience_names}; do
  S3_PATH="${INPUT_PATH}/${audience_name}"
  check_await ${S3_PATH}/_SUCCESS
  java -cp ../${JAR} mobvista.dmp.datasource.rtdmp.RTDmpRequestV2 "${audience_name}" "${S3_PATH}"
done
