CREATE EXTERNAL TABLE `dm_install_list`
PARTITIONED BY (
  year string,
  month string,
  day string,
  business string
) ROW FORMAT SERDE 'mobvista.dataplatform.text.TextSerde'
STORED AS TEXTFILE
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_list'
TBLPROPERTIES (
  'schema.url'='s3://mob-emr-test/dataplatform/DataWareHouse/schema/dwh/dm_install_list/dm_install_list.avsc'
)

CREATE EXTERNAL TABLE dwh.`dm_install_list_v1`
PARTITIONED BY (
  year string,
  month string,
  day string,
  business string
) ROW FORMAT SERDE 'mobvista.dataplatform.text.TextSerde'
STORED AS TEXTFILE
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_list_v1'
TBLPROPERTIES (
  'schema.url'='s3://mob-emr-test/dataplatform/DataWareHouse/schema/dwh/dm_install_list/dm_install_list.avsc'
)

USE dwh;
CREATE EXTERNAL TABLE dwh.`dm_install_list`(
  device_id string,
  device_type string,
  platform string,
  install_list string
)
PARTITIONED BY (
  dt string,
  business string
) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_list';

USE dwh;
DROP TABLE IF EXISTS dwh.dmp_install_daily;
CREATE EXTERNAL TABLE dwh.`dmp_install_daily`(
  device_id string,
  device_type string,
  platform string,
  install_list string
)
PARTITIONED BY (
  dt string,
  business string
) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_install_daily';

USE dwh;
DROP TABLE IF EXISTS dwh.dmp_device_tag_daily;
CREATE EXTERNAL TABLE dwh.`dmp_device_tag_daily`(
    device_id string,
    device_type string,
    platform string,
    package_name string,
    interest_tag string
) PARTITIONED BY (
    dt string,
    source string,
    business string
) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
    'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
    'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_device_tag_daily';