#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :dsp_join_m_1_day.sh
# @author  :liushuai
# @revision:2017-05-17 10:45
# @desc    ：M系统与dsp交集(1天)
# @desc : 依赖merge_m_country.sh
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_DSP="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_dsp_request_daily/${year}/${month}/${day}/"
INPUT_M="${REQUEST_TMP_PATH}/etl_adn_sdk_request_daily/${year}/${month}/${day}/"
OUTPUT="${REQUEST_TMP_PATH}/dsp_join_m_1_day/${year}/${month}/${day}/"

check_await "${INPUT_M}/_SUCCESS"


hadoop fs -rmr ${OUTPUT}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.DspJoinMMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${INPUT_DSP} ${INPUT_M} ${OUTPUT}

if [ $? -ne 0 ];then
  exit 255
fi