#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :get_m_country.sh
# @author  :liushuai
# @revision:2017-05-18 14:45
# @desc    ：dsp 3天数据合并
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-8 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

LOG_TIME=$(date +%Y%m%d -d "-3 day $ScheduleTime")
day2=${LOG_TIME:6:2}
LOG_TIME=$(date +%Y%m%d -d "-4 day $ScheduleTime")
day3=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_DSP="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_dsp_request_daily/${year}/${month}/${day}/"
OUTPUT="${REQUEST_TMP_PATH}/merge_dsp_3_day/${year}/${month}/${day}/"

hadoop fs -rmr ${OUTPUT}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.MergeDspCountryMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${INPUT_DSP} ${OUTPUT}

if [ $? -ne 0 ];then
  exit 255
fi