#!/bin/bash

######################################################################
# autor: fengliang
# date:  20170518
# desc:  生成标签报表
######################################################################

source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
date=$(date +%Y%m%d -d "-1 days $ScheduleTime")
date_path=${date:0:4}/${date:4:2}/${date:6:2}

REPORT_FILE="${TAG_REPORT_PATH}/${date_path}/DMP标签数据报表-${date}.xls"

hadoop fs -test -e ${TAG_REPORT_PATH}/${date_path}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${TAG_REPORT_PATH}/${date_path}
fi

hadoop jar ../${JAR} mobvista.prd.datasource.main.GenerateTagReport \
  -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
  $date $REPORT_FILE
if [ $? -ne 0 ];then
  exit 255
fi