package mobvista.dmp.datasource.adnnet.mapreduce;

import mobvista.dmp.common.CommonMapReduce;
import mobvista.dmp.common.CommonMapper;
import mobvista.dmp.common.CommonReducer;
import mobvista.dmp.datasource.setting.AppidPackageDictMR;
import mobvista.dmp.util.MRUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * author: houying
 * date  : 17-3-9
 * desc  :
 */
public class AppidPackageMR extends CommonMapReduce {
    private static final Logger logger = LoggerFactory.getLogger(AppidPackageMR.class);

    public static class AppidPackageMapper extends Mapper<LongWritable, Text, Text, NullWritable> {
        private ObjectMapper objectMapper = new ObjectMapper();
        private Text outKey = new Text();

        @Override
        protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String line = value.toString();
            String[] array = MRUtils.SPLITTER.split(line, -1);
            if (array.length != 4) {
                return;
            }
            try {
                JsonNode jsonNode = objectMapper.readTree(array[2]);
                String appid = jsonNode.get("appId").asText();
                String packageName = jsonNode.get("packageName").asText();
                int platform = jsonNode.get("platform").asInt();
                String p = "unknown";
                if (platform == 1) {
                    p = "adr";
                } else if (platform == 2) {
                    p = "ios";
                }
                outKey.set(MRUtils.JOINER.join(appid, packageName, p));
                context.write(outKey, NullWritable.get());
            } catch (Exception e) {
                logger.error(array[2]);
            }
        }
    }

    public static class AppidPackageReducer extends CommonReducer {
        @Override
        protected void reduce(Text key, Iterable<Text> values, Context context)
                throws IOException, InterruptedException {
            context.write(key, NullWritable.get());
        }
    }

    public AppidPackageMR(String name, Class<? extends Mapper> mapperClass, Class<? extends Reducer> reducerClass) {
        super(name, mapperClass, reducerClass);
    }

    @Override
    protected void setOutputPath(Job job, String[] args) throws IOException {

    }

    @Override
    protected void setInputPath(Job job, String[] args) throws IOException {

    }

    @Override
    protected void otherSetting(Job job, String[] args) throws Exception {
        job.setMapOutputValueClass(NullWritable.class);
    }

    public static void main(String[] args) throws Exception {
        start(new AppidPackageMR("appid package mapping", AppidPackageMapper.class, AppidPackageReducer.class), args);
    }
}
