package mobvista.dmp.datasource.personagraph;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;

/**
 *
 */
public class DataFileReader implements Runnable {
    private BlockingQueue blockingQueue;
    private BufferedReader fileReader;
    private Boolean readable = true;

    public DataFileReader(BlockingQueue blockingQueue, BufferedReader fileReader) {
        this.blockingQueue = blockingQueue;
        this.fileReader = fileReader;
    }

    public void setFileReader(BufferedReader fileReader) {
        this.fileReader = fileReader;
    }

    public void setReadable(Boolean readable) {
        this.readable = readable;
    }

    @Override
    public void run() {
        try {
            String line = fileReader.readLine();
            while (line != null) {
                if (!readable) {
                    Thread.sleep(20000);
                } else {
                    blockingQueue.put(line);
                    line = fileReader.readLine();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                fileReader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
