package mobvista.dmp.datasource.realtime.service;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import mobvista.dmp.datasource.baichuan.AsoDevice;
import mobvista.dmp.datasource.baichuan.BaiChuanServer;
import mobvista.dmp.util.PropertyUtil;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDataSource;
import ru.yandex.clickhouse.ClickHousePreparedStatement;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

import java.sql.SQLException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.*;

/**
 * @package: mobvista.dmp.datasource.realtime.service
 * @author: wangjf
 * @date: 2019-10-24
 * @time: 17:29
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class RealTimeServiceNewMain {
    private static final String[] SET_VALUES = PropertyUtil.getProperty("config.properties", "http.private.host.server.ip").split(",");
    private static String driver = PropertyUtil.getProperty("config.properties", "datasource.clickhouse.driverClassName");
    private static String url = PropertyUtil.getProperty("config.properties", "datasource.clickhouse.url");
    private static String username = PropertyUtil.getProperty("config.properties", "datasource.clickhouse.username");
    private static String password = PropertyUtil.getProperty("config.properties", "datasource.clickhouse.password");
    private static String database = PropertyUtil.getProperty("config.properties", "datasource.clickhouse.database");
    private static int timeout = Integer.parseInt(PropertyUtil.getProperty("config.properties", "datasource.clickhouse.timeout"));

    private static Set<AsoDevice> deviceInfoSet = new CopyOnWriteArraySet<>();

    public static void main(String[] args) throws JoranException {
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(context);
        context.reset();
        configurator.doConfigure(BaiChuanServer.class.getClassLoader().getResourceAsStream("logback-syslog.xml"));
        Logger logger = context.getLogger("realtime-service-new");

        String date = "";
        String hour = "";
        String region = "";
        if (args.length >= 3) {
            date = args[0];
            hour = args[1];
            region = args[2];
        } else {
            logger.info("Please Input date hour region");
            System.exit(1);
        }
        long start = System.currentTimeMillis();
        ClickHouseProperties properties = new ClickHouseProperties();
        properties.setUser(username);
        properties.setPassword(password);
        properties.setDatabase(database);
        properties.setSocketTimeout(timeout);
        properties.setConnectionTimeout(timeout);

        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder()
                .setNameFormat("realtime-service-%d").build();

        ExecutorService realtimePool = new ThreadPoolExecutor(3, 5,
                360L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(1024), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        for (int ipId = 0; ipId < SET_VALUES.length; ipId++) {
            int finalIpId = ipId;
            String finalDate = date;
            String finalHour = hour;
            String finalRegion = region;
            realtimePool.execute(() -> {
                String[] ips = SET_VALUES[finalIpId].split(":");
                ClickHouseDataSource dataSource = new ClickHouseDataSource(url.replace("host", ips[new Random().nextInt(2)]), properties);
                ClickHouseConnection connection = null;
                ClickHousePreparedStatement preparedStatement = null;
                try {
                    try {
                        connection = dataSource.getConnection();
                    } catch (ClickHouseException e) {
                        Thread.sleep(200);
                        System.exit(255);
                    }
                    assert connection != null;
                    preparedStatement = (ClickHousePreparedStatement) connection.prepareStatement(buildSql(finalDate, finalHour, finalRegion));
                    preparedStatement.execute();
                } catch (SQLException | InterruptedException e) {
                    System.exit(255);
                    e.printStackTrace();
                } finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        realtimePool.shutdown();

        long end = System.currentTimeMillis();
        logger.info("all runtime ==>> " + (end - start));
    }

    private static String buildSql(String date, String hour, String region) {
        String insertSql = "INSERT INTO dwc.realtime_service_result (dt, hour, region, device_id, country, age, gender, install_apps, interest, frequency, flag) " +
                "SELECT a.dt, a.hour, a.region, a.device_id, UPPER(a.country) country, a.age, a.gender, a.install_apps, a.interest, '', 2 flag " +
                "FROM (SELECT * FROM dwh.realtime_service_hour WHERE dt = '@date' AND hour = '@hour' AND region = '@region') a ANY LEFT JOIN " +
                "(SELECT * FROM dwc.realtime_service_result_all WHERE dt = '@date' AND hour = '@hour' AND region = '@region') b USING device_id, region WHERE b.device_id = ''";

        return insertSql.replace("@date", date)
                .replace("@hour", hour)
                .replace("@region", region);
    }
}
