package mobvista.dmp.datasource.rtdmp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.taobao.api.ApiException;
import mobvista.dmp.common.Constants;
import mobvista.dmp.util.DateUtil;
import mobvista.dmp.util.MD5Util;
import mobvista.dmp.util.PropertyUtil;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @package: mobvista.dmp.datasource.rtdmp
 * @author: wangjf
 * @date: 2021/8/2
 * @time: 3:08 下午
 * @email: jinfeng.wang@mobvista.com
 */
public class RTDmpAlter {
    public static final Logger logger = LoggerFactory.getLogger(ServerMain.class);

    private static final String BASE_URL = PropertyUtil.getProperty("config.properties", "rtdmp.url");

    public static void main(String[] args) {
        String update_time_start;
        String update_time_end;
        if (args.length >= 2) {
            update_time_start = args[0];
            update_time_end = args[1];
        } else {
            Calendar cal = Calendar.getInstance();
            Date date = new Date();
            cal.setTime(date);
            cal.add(Calendar.DATE, -7);
            update_time_start = DateUtil.format(cal.getTime(), "yyyy-MM-dd 00") + ":00:00";
            cal.setTime(date);
            cal.add(Calendar.DATE, -1);
            update_time_end = DateUtil.format(cal.getTime(), "yyyy-MM-dd 23") + ":59:59";
        }

        JSONObject requestBody = new JSONObject();
        requestBody.put("update_time_start", update_time_start);
        requestBody.put("update_time_end", update_time_end);

        CloseableHttpClient client = HttpClients.createDefault();

        List<BasicNameValuePair> formparams = new ArrayList<>();

        String serverUrl = BASE_URL + "rtdmp/audience/query";
        URIBuilder uri = new URIBuilder();
        try {
            uri = new URIBuilder(serverUrl)
                    .addParameter("update_time_start", update_time_start)
                    .addParameter("update_time_end", update_time_end)
                    .addParameter("audience_type", "3")
                    .addParameter("is_offline", "1");
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000).setConnectionRequestTimeout(5000)
                .setSocketTimeout(5000).build();

        HttpGet httpGet = new HttpGet();
        try {
            logger.info("uri -->> " + uri.build());
            httpGet = new HttpGet(uri.build());
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }


        String key = UUID.randomUUID().toString();
        String token = MD5Util.getMD5Str(key);

        httpGet.setHeader("Auth-System", "dmp");
        httpGet.setHeader("Content-Type", "text/plain");
        httpGet.setHeader("key", key);
        httpGet.setHeader("token", token);

        CloseableHttpResponse response;

        JSONObject jsonObject;
        try {
            response = client.execute(httpGet);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            jsonObject = Constants.String2JSONObject(result.toString());
        } catch (IOException e) {
            jsonObject = new JSONObject();
            logger.info(e.getMessage());
        } finally {
            httpGet.abort();
        }

        JSONArray data = jsonObject.getJSONArray("data");

        Set<Integer> set = new HashSet<>();
        for (int i = 0; i < data.size(); i++) {
            set.add(data.getJSONObject(i).getIntValue("id"));
        }
        if (set.size() > 0) {
            System.out.println(set);
            dingTalkAlert(set);
        }
    }

    private static void dingTalkAlert(Set<Integer> set) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/robot/send?access_token=7b176034a8d87c77463b5c5296974a9a000774da18f245021a368839e69dcf97");
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle("运算人群包更新告警");

        markdown.setText("#### 截止 " + sdf.format(new Date()) + " 未更新的运算人群包有:\n" +
                ">" + set + "\n" +
                "> ###### 请注意 @15210627698! \n");
        request.setMarkdown(markdown);

        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles(Arrays.asList("15210627698"));
        at.setIsAtAll(false);
        request.setAt(at);
        OapiRobotSendResponse response = null;
        try {
            response = client.execute(request);
        } catch (ApiException e) {
            logger.error(e.getMessage());
        }
        System.out.println(response.getMsg());
    }
}
