package mobvista.dmp.datasource.tracking.mapreduce;

import mobvista.dmp.common.CommonMapReduce;
import mobvista.dmp.common.InstallTotalReducer;
import mobvista.dmp.datasource.age.mapreduce.CalcDeviceAgeMR;
import mobvista.dmp.util.MRUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

import java.io.IOException;

/**
 * Created by liushuai on 2017/3/20 0020.
 */
public class TrackingInstallTotalMR {
    public static void main(String[] args) throws InterruptedException, IOException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.map.speculative", "true");
        conf.set("mapreduce.reduce.speculative", "true");
        conf.set("mapreduce.task.io.sort.mb", "500");
        conf.set("mapreduce.reduce.java.opts", "-Xmx1536m");
        conf.set("mapreduce.reduce.memory.mb", "2048");
        conf.set("mapreduce.reduce.shuffle.parallelcopies", "50");
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "TrackingInstallTotalMR");

        job.setJarByClass(CalcDeviceAgeMR.class);
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);

        job.setMapperClass(TrackingInstallDailyMapper.class);
        job.setReducerClass(InstallTotalReducer.class);

        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(NullWritable.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileInputFormat.addInputPath(job, new Path(otherArgs[1]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[2]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);

    }

    public static class TrackingInstallDailyMapper extends Mapper<LongWritable, Text, Text, Text> {
        Text outKey = new Text();
        Text outValue = new Text();

        public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String[] array = MRUtils.SPLITTER.split(value.toString(), -1);
            if (array.length == 6) { // 3s install daily
                outKey.set(MRUtils.JOINER.join(array[0], array[1], array[2]));
                outValue.set(MRUtils.JOINER.join(array[3], array[4]));
            } else if (array.length == 4) { // 3s install total
                outKey.set(MRUtils.JOINER.join(array[0], array[1], array[2]));
                outValue.set(array[3]);
            } else {
                CommonMapReduce.setMetrics(context,"DMP","column_num_error", 1);
                return;
            }
            context.write(outKey, outValue);
        }
    }
}
