package mobvista.dmp.main;

import mobvista.dmp.format.RCFileMultipleOutputForamt;
import mobvista.dmp.format.RCFileOutputFormat;
import mobvista.dmp.util.BytesRefUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

import java.io.IOException;

public class Convert2RCFile extends Configured implements Tool {

    public static class ConvertMapper extends Mapper<LongWritable, Text, LongWritable, BytesRefArrayWritable> {

        @Override
        protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            context.write(key, BytesRefUtil.createRcOutValue(value.toString()));
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        Configuration conf = getConf();
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        conf.set("mapreduce.output.fileoutputformat.compress.type",
                SequenceFile.CompressionType.BLOCK.toString());
        conf.setClass("mapreduce.output.fileoutputformat.compress.codec",
                GzipCodec.class, CompressionCodec.class);
        conf.set("mapreduce.job.reduce.slowstart.completedmaps", "0.7");

        RCFileOutputFormat.setColumnNumber(conf, 4);

        Job job = Job.getInstance(conf, "Convert text to RCFile");
        job.setNumReduceTasks(Integer.parseInt(args[2]));
        job.setJarByClass(Convert2RCFile.class);
        job.setMapperClass(ConvertMapper.class);
        job.setReducerClass(ParseInstallRCFile.ConvertReducer.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(BytesRefArrayWritable.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(BytesRefArrayWritable.class);
        job.setOutputFormatClass(RCFileOutputFormat.class);

        FileInputFormat.addInputPath(job, new Path(args[0]));
        FileOutputFormat.setOutputPath(job, new Path(args[1]));

       // job.addFileToClassPath(new Path("s3://mob-emr-test/feng.liang/lib/hive-exec-0.13.1-amzn-3.jar"));
        job.addFileToClassPath(new Path("s3://mob-emr-test/dataplatform/env/hive/lib/hive-exec-2.3.3.jar"));


        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) {
        int exitCode = 0;
        try {
            exitCode = ToolRunner.run(new Configuration(), new Convert2RCFile(), args);
        } catch (Exception e) {
            exitCode = -1;
            e.printStackTrace();
        } finally {
            System.exit(exitCode);
        }
    }
}
