package mobvista.prd.datasource.newall;

import mobvista.prd.datasource.util.MRUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/4/29 0029.
 */
public class AgeGenderAllMR {
    public static void main(String[] args) throws InterruptedException, IOException, ClassNotFoundException {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "DmpYearMR");
        job.setNumReduceTasks(1);
        job.setJarByClass(AgeGenderAllMR.class);

        job.setMapperClass(DmpYearMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(NullWritable.class);

        job.setReducerClass(DmpYearReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(NullWritable.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[1]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }
    public static class DmpYearMapper extends Mapper<LongWritable, Text, Text, NullWritable> {
        Text outKey = new Text();
        ObjectMapper objectMapper = new ObjectMapper(); //转换器
        JavaType mapType = objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Map.class);
        Long one = 0L;
        Long two = 0L;
        Long three = 0L;
        Long four = 0L;
        Long five = 0L;
        public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String line = value.toString();
            String[] fields = MRUtils.SPLITTER.split(line, -1);
            if (fields.length != 5) {
                return;
            }
            String age;
            String maxAge;
            Map<String, Map> ageMap = objectMapper.readValue(fields[3], mapType);
            Map<String, String> ageSource = ageMap.get("age_and_source");
            Map<String, Double> ageProportion = ageMap.get("age_and_proportion");
            List maxAgeList = getMaxRatio(ageProportion);
            maxAge = (String) maxAgeList.get(0);
            if (maxAge.equals("0至18岁")) {
                one++;
            }
            if (maxAge.equals("18至25岁")) {
                two++;
            }
            if (maxAge.equals("25至45岁")) {
                three++;
            }
            if (maxAge.equals("45至60岁")) {
                four++;
            }
            if (maxAge.equals("60岁以上")) {
                five++;
            }
        }
        public void cleanup(Context context) throws IOException, InterruptedException {
            outKey.set(MRUtils.JOINER.join(one,two,three,four,five));
            context.write(outKey,NullWritable.get());
        }
    }
    public static class DmpYearReducer extends Reducer<Text, NullWritable, Text, NullWritable> {
        Text outKey = new Text();
        Long one = 0L;
        Long two = 0L;
        Long three = 0L;
        Long four = 0L;
        Long five = 0L;

        public void reduce(Text key, Iterable<NullWritable> values, Context context)
                throws IOException, InterruptedException {

            String line = key.toString();
            String[] fields = MRUtils.SPLITTER.split(line, -1);
            one = one + Integer.parseInt(fields[0]);
            two = two + Integer.parseInt(fields[1]);
            three = three + Integer.parseInt(fields[2]);
            four = four + Long.parseLong(fields[3]);
            five = five + Integer.parseInt(fields[4]);
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            outKey.set(MRUtils.JOINER.join(one, two, three, four, five));
            context.write(outKey, NullWritable.get());
        }
    }
    public static List getMaxRatio(Map<String,Double> ageMap)  {
        String maxAge = "";
        double maxRatio = 0.0;
        for (Map.Entry<String, Double> entry : ageMap.entrySet()) {
            String ages = entry.getKey();
            Double ratio = entry.getValue();
            if (ages != null && !ages.equals("")) {
                if (maxAge.length() == 0) {
                    maxAge = ages;
                    maxRatio = ratio;
                }else if (maxRatio < ratio) {
                    maxAge = ages;
                    maxRatio = ratio;
                }
            }
        }
        List maxRatioList = new ArrayList<>();
        maxRatioList.add(maxAge);
        maxRatioList.add(maxRatio);
        return maxRatioList;
    }
}
