package mobvista.prd.datasource.source.mapreduce;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import mobvista.prd.datasource.newall.CrossMR;
import mobvista.prd.datasource.table.MergeAppIDMR;
import mobvista.prd.datasource.tag.mapreduce.AgeTotalJob;
import mobvista.prd.datasource.util.MRUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * Created by Administrator on 2017/5/16 0016.
 * desc:分国家统计dsp与M重合设备去重
 */
public class MergeCountryMJoinDspMR {
    public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

        Job job = Job.getInstance(conf, "m join dsp");

        job.setJarByClass(MergeAppIDMR.class);
        FileOutputFormat.setCompressOutput(job, true);
        FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);

        job.setMapperClass(CountCountryMJoinDspMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setReducerClass(CountCountryMJoinDspReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);

        FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath(job, new Path(otherArgs[1]));

        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class CountCountryMJoinDspMapper extends Mapper<LongWritable, Text, Text, Text> {
        Text outKey = new Text();
        Text outValue = new Text();
        public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
            String line = value.toString();
            String[] fields = line.split("\t", -1);
            outKey.set(MRUtils.JOINER.join(fields[0], fields[1]));//device_id,device_type
            outValue.set(MRUtils.JOINER.join(fields[3],fields[4]));//来源，国家
            context.write(outKey, outValue);
        }
    }
    public static class CountCountryMJoinDspReducer extends Reducer<Text, Text, Text, Text> {
        private static final Logger log = Logger.getLogger(AgeTotalJob.class);
        Text outKey = new Text();
        Text outValue = new Text();
        public void reduce(Text key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
            Set<String> set = Sets.newHashSet();
            for (Text val : values) {
                set.add(val.toString());
            }
            for (String source : set) {
                outKey.set(key);//device_id,device_type
                outValue.set(source);//来源，国家
                context.write(outKey,outValue);
            }
        }
    }

}
