package mobvista.prd.datasource.tag.mapreduce.reduce;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;

/**
 * Created by fl on 2017/5/11.
 */
public class CountReducer extends Reducer<Text, LongWritable, Text, LongWritable> {

    private LongWritable outVal = new LongWritable();

    @Override
    protected void reduce(Text key, Iterable<LongWritable> values, Context context) throws IOException, InterruptedException {
        long count = 0;
        for (LongWritable val : values) {
            count += val.get();
        }

        outVal.set(count);
        context.write(key, outVal);
    }
}
