package mobvista.prd.datasource.udf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mobvista.prd.datasource.util.GsonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

import java.util.ArrayList;
import java.util.List;

public class ExpansionTags extends GenericUDTF {
    private static final String dataSplit = "\t";
    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length !=1) {
            throw new UDFArgumentLengthException("ExplodeMap takes only one argument");
        }
        if (args[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ExplodeMap takes string as a parameter");
        }

        List<String> fieldNames = new ArrayList<>();
        List<ObjectInspector> fieldOIs = new ArrayList<>();
        fieldNames.add("firstTag");
        fieldNames.add("secondTag");
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] args) throws HiveException {
        String record = String.valueOf(args[0]);
        List<String> list = new ArrayList<>();
        if (record != null && record.startsWith("[")) {
            JsonArray array = GsonUtil.String2JsonArray(record);
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                JsonArray tagArray = obj.get("tag").getAsJsonArray();
                for (JsonElement tagElement : tagArray) {
                    JsonObject tagObj = tagElement.getAsJsonObject();
                    String firstLevel = tagObj.get("1") != null ? tagObj.get("1").getAsString() : "";
                    String secondLevel = tagObj.get("2") != null ? tagObj.get("2").getAsString() : "";

                    list.clear();
                    list.add(firstLevel);
                    list.add(secondLevel);

                    forward(list.toArray());
                }
            }
        } else {
            list.clear();
            list.add("");
            list.add("");
            forward(list.toArray());
        }
    }

    @Override
    public void close() throws HiveException {

    }
}
