package mobvista.dmp.datasource.adn_sdk

import java.util

import mobvista.dmp.common.CommonInstallListV2
import mobvista.dmp.datasource.mpsdk.InstallInfo
import mobvista.prd.datasource.util.GsonUtil
import org.apache.spark.sql.Row

import scala.collection.JavaConversions._

/**
  * 刘凯      2018-01-19 11:30
  * 将adn_sdk天数据合并到安装列表全量数据中
  */
class AdnSdkInstallListV2 extends CommonInstallListV2 {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  def processDailyData(iters: Iterator[Row], date: String): Iterator[Tuple2[String, InstallInfo]] = {
    //  val buffer = new ArrayBuffer[Tuple2[String, InstallInfo]]()
    val buffer = new util.ArrayList[Tuple2[String, InstallInfo]]()
    while (iters.hasNext) {
      val iter = iters.next
      val buffer = new util.ArrayList[Tuple2[String, InstallInfo]]()
      val device_id = iter.getAs("device_id").toString
      val device_type = iter.getAs("device_type").toString
      val platform = iter.getAs("platform").toString
      val pkgList = iter.getAs("install_list").toString
      val set = new util.HashSet[InstallInfo]()
      val jsonArray = GsonUtil.String2JsonArray(pkgList)
      jsonArray.foreach(element => {
        set.add(GsonUtil.fromJson(element, classOf[InstallInfo]))
      })
      set.iterator()
        .foreach(installInfo => {
          buffer.add(Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", installInfo))
        })
    }
    import scala.collection.JavaConverters._
    buffer.asScala.iterator
  }
}

object AdnSdkInstallListV2 {
  def main(args: Array[String]): Unit = {
    new AdnSdkInstallListV2().run(args)
  }
}