package mobvista.dmp.datasource.adn_sdk

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily, TagDaily}
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils
import org.apache.spark.sql.{DataFrame, SparkSession}

import java.text.SimpleDateFormat
import scala.collection.JavaConversions._
import scala.collection.mutable
import scala.collection.mutable.ArrayBuffer

/**
 * @package: mobvista.dmp.datasource.adn
 * @author: wangjf
 * @date: 2019/3/19
 * @time: 下午1:51
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
class AdnSdkTagDaily extends MatchInterestTagDaily with Serializable {
  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = Constant.adn_sdk_sql.replace("@dt", date)

    import spark.implicits._
    val rdd = spark.sql(sql).rdd.mapPartitions(rs => {
      rs.map(r => {
        TagDaily(r.getAs("device_id"), r.getAs("device_type"), r.getAs("platform"), r.getAs("install_list"))
      })
    }).flatMap(r => {
      val buffer = new ArrayBuffer[TagDaily]()
      val device_id = r.device_id
      val device_type = r.device_type
      val platform = r.platform
      val install_list = r.package_name
      val set = new mutable.HashSet[String]()
      if (StringUtils.isNotBlank(install_list) && install_list.startsWith("[") && install_list.endsWith("]")) {
        val jsonArray = GsonUtil.String2JsonArray(install_list)
        jsonArray.foreach(jsonElement => {
          val json = jsonElement.getAsJsonObject
          val package_name = if (json.has("package_name") && json.get("packge_name") != null) {
            json.get("package_name").getAsString
          } else {
            ""
          }
          val update_date = json.get("date").getAsString
          val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
          val sdf2 = new SimpleDateFormat("yyyyMMdd")
          val date2 = sdf1.format(sdf2.parse(date))
          if (update_date.equals(date2) && StringUtils.isNotBlank(package_name)) {
            set.add(package_name)
          }
        })
      }
      set.map(package_name => {
        buffer += TagDaily(device_id, device_type, platform, package_name)
      })
      buffer
    })
    rdd.toDF
  }
}

object AdnSdkTagDaily {
  def main(args: Array[String]): Unit = {
    new AdnSdkTagDaily().run(args)
  }
}

