package mobvista.dmp.datasource.baichuan

import java.text.SimpleDateFormat

import mobvista.dmp.datasource.newtag.MatchInterestTagDaily
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @package: mobvista.dmp.datasource.baichuan
  * @author: wangjf
  * @date: 2019/3/19
  * @time: 下午3:53
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class AliTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val date2 = sdf1.format(sdf2.parse(date))
    val sql = mobvista.dmp.datasource.newtag.Constant.ali_sql.replace("@dt", date2)

    spark.sql(sql)
  }
}

object AliTagDaily {
  def main(args: Array[String]): Unit = {
    new AliTagDaily().run(args)
  }
}