package mobvista.dmp.datasource.bytedance

import java.text.SimpleDateFormat

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * @package: mobvista.dmp.datasource.bytedance
  * @author: wangjf
  * @date: 2019/3/19
  * @time: 下午3:53
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class ByteDanceTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val date2 = sdf1.format(sdf2.parse(date))
    val sql = Constant.bytedance_sql.replace("@dt", date2)

    spark.sql(sql)
  }
}

object ByteDanceTagDaily {
  def main(args: Array[String]): Unit = {
    new ByteDanceTagDaily().run(args)
  }
}