package mobvista.dmp.datasource.clever

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo
import org.apache.commons.lang.StringUtils

/**
  * 将天数据合并到安装列表全量数据中
  */
class CleverInstallList extends CommonInstallList {

  /**
    * 解析天处理结果数据
    * @param array
    * @param date
    * @return
    */
  def processDailyData(array: Array[String], date: String): Array[Tuple2[String, InstallInfo]] = {
    val key = s"${array(0)}$FIELD_SPLIT${array(1)}$FIELD_SPLIT${array(2)}" //device_id, device_type, platform
    val value = new InstallInfo(array(5), date)                            // package
    val result = new Array[Tuple2[String, InstallInfo]](1)
    result(0) = Tuple2(key, value)
    result
  }
}

object CleverInstallList {
  def main(args: Array[String]): Unit = {
    new CleverInstallList().run(args)
  }
}