package mobvista.dmp.datasource.iqiyi

/**
  * @package: mobvista.dmp.datasource.iqiyi
  * @author: wangjf
  * @date: 2020/5/9
  * @time: 2:15 下午
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
object Constant {

  case class IQiYiEntity(device_id: String, device_type: String, platform: String, package_name: String, country: String)

  val iqiyi_sql: String =
    s"""
       |SELECT * FROM dwh.etl_iqiyi_install_daily_all WHERE dt = '@date' AND
       |  package_name != '0000000000' AND package_name != 'com.nonepkg.nonepkg'
    """.stripMargin

  val iqiyi_lahuo_sql: String =
    s"""
       |SELECT device_ids FROM dwh.iqiyi_lahuo_result_daily_all WHERE dt = '@date' AND hour BETWEEN '08' AND '15'
    """.stripMargin

  def buildPart(partSize: Int): Seq[String] = {
    var list: scala.List[String] = scala.List()
    for (i <- 0 until partSize) {
      list = list.::(s"CRC32(device_id) % $partSize = $i")
    }
    list = list.reverse
    list
  }

  def buildPartLaHuo(partSize: Int): Seq[String] = {
    var list: scala.List[String] = scala.List()
    for (i <- 0 until partSize) {
      list = list.::(s"CRC32(device_ids) % $partSize = $i")
    }
    list = list.reverse
    list
  }
}
