package mobvista.dmp.datasource.postback_3s

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

import scala.collection.mutable.ArrayBuffer

class PostBackInstallList extends CommonInstallList {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  override def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val apps = array(3).split("#")
    apps.foreach(r => {
      buffer += Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", new InstallInfo(r, date))
    })
    buffer.toArray
  }
}

object PostBackInstallList {
  def main(args: Array[String]): Unit = {
    new PostBackInstallList().run(args)
  }
}