package mobvista.dmp.datasource.tracking_3s

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * 处理 3s 天数据
  */
class TrackingTagDaily extends MatchInterestTagDaily {

  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */

  def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = Constant.tracking_3s_sql.replace("@dt", date)
    spark.sql(sql)
  }
}

object TrackingTagDaily {

  def main(args: Array[String]): Unit = {
    new TrackingTagDaily().run(args)
  }
}