package mobvista.dmp.runner

import java.io._
import java.util.concurrent.CountDownLatch

import mobvista.prd.datasource.util.{GsonUtil, HttpUtil}
import org.apache.log4j.Logger

/**
  * match trackId by ios bundleId
  * Created by fl on 2017/7/13.
  */
class MatchTask(inputPath: String, outputPath: String, doneSignal: CountDownLatch) extends Thread {
  val dataSplit = "\t"
  val reqUrl = "http://itunes.apple.com/lookup?bundleId=%s&country=US"
  val log = Logger.getLogger(classOf[MatchTask])

  override def run(): Unit = {
    var reader: BufferedReader = null
    var writer: BufferedWriter = null

    try {
      var count = 0
      writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputPath)))
      reader = new BufferedReader(new FileReader(inputPath))
      var line = reader.readLine()
      while (line != null) {
        try {
          val result = HttpUtil.getRequest(String.format(reqUrl, line), null, log)
          val json = GsonUtil.String2JsonObject(result)
          if (json.get("results") != null) {
            val jsonArray = json.get("results").getAsJsonArray
            if (jsonArray.size() > 0) {
              writer.write(line)
              writer.write(dataSplit)
              writer.write(jsonArray.get(0).getAsJsonObject.get("trackId").getAsString)
              writer.newLine()
            } else {
              count = count + 1
              log.info(line)
              log.debug("results jsonArray.size() == 0 ; bundle " + line)
            }
          }

          if (count % 10 == 0) {
            log.info(Thread.currentThread().getName + " has processed " + count + " bundles")
          }

        } catch {
          case e: Exception => {
            e.printStackTrace()
          }
        }

        Thread.sleep(2000)
        line = reader.readLine()
      }
      log.info(Thread.currentThread().getName + " input file : " + inputPath)
      log.info(Thread.currentThread().getName + " has " + count + " packages result JsonArray.size() == 0")
    } catch {
      case e: Exception => {
        e.printStackTrace()
      }
    } finally {
      doneSignal.countDown()
      if (reader != null) {
        reader.close()
      }
      if (writer != null) {
        writer.flush()
        writer.close()
      }
    }
  }
}