/*
 * Decompiled with CFR 0.152.
 */
package shade.io.clickhouse.apache.commons.pool2.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class EvictionTimer {
    private static ScheduledThreadPoolExecutor executor;
    private static int usageCount;

    private EvictionTimer() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvictionTimer []");
        return builder.toString();
    }

    static synchronized void schedule(Runnable task, long delay, long period) {
        if (null == executor) {
            executor = new ScheduledThreadPoolExecutor(1, new EvictorThreadFactory());
        }
        ++usageCount;
        executor.scheduleWithFixedDelay(task, delay, period, TimeUnit.MILLISECONDS);
    }

    static synchronized void cancel(TimerTask task, long timeout, TimeUnit unit) {
        task.cancel();
        if (--usageCount == 0) {
            executor.shutdown();
            try {
                executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executor.setCorePoolSize(0);
            executor = null;
        }
    }

    private static class EvictorThreadFactory
    implements ThreadFactory {
        private EvictorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            final Thread t = new Thread(null, r, "commons-pool-evictor-thread");
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    t.setContextClassLoader(EvictorThreadFactory.class.getClassLoader());
                    return null;
                }
            });
            return t;
        }
    }
}

