#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : 3s_tracking_interest_install.sh
# @author: liushuai
# @date  : 17-03-21
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


INPUT_INSTALL_PATH="${DM_INSTALL_LIST}/${year}/${month}/${day}/3s"
INPUT_APP_TAG_PATH="$APP_TAG_PATH/${year}/${month}/${day}/"
OUTPUT_PATH="${DM_INTEREST_PATH}/${year}/${month}/${day}/3s"

check_await "$INPUT_APP_TAG_PATH/_SUCCESS"

REDUCE_NUM=$(calculate_reduce_num "$INPUT_INSTALL_PATH")

REDUCE_NUM=20

hadoop fs -rm -r ${OUTPUT_PATH}

hadoop jar ../${JAR} mobvista.dmp.common.InterestDeviceDistinctMR \
      -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
      -Dmapreduce.map.memory.mb=4096 \
      -Dmapreduce.map.java.opts=-Xmx2458m \
      -Dmapreduce.reduce.memory.mb=4096 \
      -Dmapreduce.reduce.java.opts=-Xmx2458m \
      -Dmapred.max.split.size=536870912 \
      -Dmapred.min.split.size.per.node=536870912 \
      -Dmapred.min.split.size.per.rack=536870912 \
      "$INPUT_APP_TAG_PATH/part-r-00000" "$INPUT_INSTALL_PATH" "$OUTPUT_PATH" "3s install interest job"

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_interest_tag" "year='$year', month='$month', day='$day', business='3s'" "$OUTPUT_PATH"

echo "[3s Install + Interest Tag Total End!]"