#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : dim_campaign_3s_list.sh
# @author: liushuai
# @date  : 17-03-24
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

mysql -hreplica-portal-mysql-external.mobvista.com -udatacenter -pPr3j5KcQlM13 -P3306 -D mob_portal -e"
        select id,platform,package_name from mob_camp_info;">>./camp.txt

OUTPUT_PATH="${DIM_CAMPAIGN_PACKAGE_3S}/${year}/${month}-${day}/"

hadoop fs -mkdir ${OUTPUT_PATH}

hadoop fs -put ./camp.txt ${OUTPUT_PATH}

rm ./camp.txt


mount_partition "dim_campaign_package_3s" "year='$year', \`date\`='$month-$day'" "$OUTPUT_PATH"