#!/bin/bash

source ../../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

business="adn_install"
DAILY_INPUT="${ETL_ADN_INSTALL_TMP_DAILY}/${year}/${month}/${day}/"
check_await "${DAILY_INPUT}/_SUCCESS"

sleep 60

INPUT_PATH="${DMP_INSTALL_LIST}/${old_year}/${old_month}/${old_day}/${business}"
check_await "${INPUT_PATH}/_SUCCESS"

OUTPUT="${DMP_INSTALL_LIST}/${year}/${month}/${day}/${business}"

mount_partition "dmp_install_list" "dt='$LOG_TIME', business='$business'" "$OUTPUT"

expire_date=$(date +%Y%m%d -d "-4 day $LOG_TIME")
expire_date_path=$(date +"%Y/%m/%d" -d "-4 day ${LOG_TIME}")
EXPIRE_OUTPUT_PATH="${DMP_INSTALL_LIST}/${expire_date_path}/${business}"

spark-submit --class mobvista.dmp.common.InstallListLogic \
     --name "DmpInstallList.${business}.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=400 \
     --conf spark.default.parallelism=400 \
     --conf spark.kryoserializer.buffer.max=256m \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g  --executor-cores 4  --num-executors 5 \
     ../../${JAR} -date ${LOG_TIME} -business ${business} -output ${OUTPUT} -coalesce 100

if [[ $? -ne 0 ]];then
  exit 255
fi

# 删除过期的分区及删除对应路径
unmount_partition "dmp_install_list" "dt='${expire_date}', business='${business}'" "${EXPIRE_OUTPUT_PATH}"