#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : adn_request_other_daily.sh
# @author: feng.liang
# @date  : 2018-05-29
# @desc  : 获取ext_packagename字段值，补充包名数据
# # # # # # # # # # # # # # # # # # # # # #


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
old_path=$(date -d "$ScheduleTime 2 days ago" "+%Y/%m/%d")
date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")
task_date=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")

INPUT_PATH="$ETL_ADN_ORG_REQ_HOURS/${date_path}/"
OUTPUT_PATH="$ETL_ADN_REQUEST_OTHER_DAILY/$date_path"

check_await "$INPUT_PATH/virginia/23/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH"


spark-submit --class mobvista.dmp.datasource.adn_request_other.EtlAdnRequestOtherDaily \
    --conf spark.sql.shuffle.partitions=2000 \
    --conf spark.yarn.executor.memoryOverhead=3048  \
    --conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
    --conf spark.default.parallelism=2000 \
    --conf spark.shuffle.memoryFraction=0.4 \
    --conf spark.storage.memoryFraction=0.4 \
    --conf spark.driver.maxResultSize=5g \
    --conf spark.executor.extraJavaOptions=-XX:+UseG1GC \
    --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 5  --num-executors 40 \
    ../../${JAR} -input "${INPUT_PATH}/*/*" -output $OUTPUT_PATH
if [ $? -ne 0 ]; then
    exit 255
fi

mount_partition "etl_adn_request_other_daily" "\`date\`='$LOG_TIME'" "$OUTPUT_PATH" || exit 1

echo "[Etl adn request other daily end!]"