#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : mds_adn_request_daily.sh
# @author: fengliang
# @date  : 2017-08-22
# @desc  : 抽取请求日志中的device_id, device_type, platform, app_id, ip, country_code, device_model, device_brand等字段
# # # # # # # # # # # # # # # # # # # # # #


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")


INPUT_ADN_SDK_PKG_DAILY="$ETL_ADN_ORG_REQ_HOURS/${date_path}"
OUTPUT_PATH="$MDS_ADN_SDK_REQUEST_DAILY/$date_path"

REDUCE_NUM=$(calculate_reduce_num ${OLD_OUTPUT})

check_await "$INPUT_ADN_SDK_PKG_DAILY/virginia/23/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH"

export HADOOP_CLIENT_OPTS="-Xmx2496m $HADOOP_CLIENT_OPTS"

hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.MdsAdnRequestDailyMR \
    -Dtask.date="$year-$month-$day" \
    -Dmapreduce.map.memory.mb=3072 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=3072 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dmapreduce.job.reduces=200 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_SDK_PKG_DAILY" "$OUTPUT_PATH" || exit 1

mount_partition "mds_adn_request_daily" "\`date\`='$LOG_TIME'" "$OUTPUT_PATH" || exit 1

echo "[Etl Adn Sdk request Daily End!]"
