#!/usr/bin/env bash

source ../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")


INPUT_GENDER_MERGE_DEVICE_PATH="${GENDER_MERGE_DEVICE}/${yesterday}"
INPUT_ODS_ADX_TMP_PATH="${ODS_ADN_ADX_REQ_TMP}/${today}"
## INPUT_DIM_PACKAGE_TAGS_PATH_PATH="${DIM_PACKAGE_TAGS_PATH}/${yesterday}"

## 一天一个分区，不删除操作
OUTPUT_ADN_ADX_DEVICE_TAG_PATH="${ADN_ADX_DEVICE_TAG}/${today}"

check_await "${INPUT_ODS_ADX_TMP_PATH}/_SUCCESS"
check_await "${INPUT_GENDER_MERGE_DEVICE_PATH}/_SUCCESS"
## check_await "${INPUT_DIM_PACKAGE_TAGS_PATH_PATH}/000000_0"


hadoop fs -rm -r "${OUTPUT_ADN_ADX_DEVICE_TAG_PATH}/"

spark-submit --class mobvista.dmp.datasource.adn_adx.AdnAdxDeviceTag \
  --conf spark.yarn.executor.memoryOverhead=3072 \
  --conf spark.network.timeout=720s \
  --conf spark.default.parallelism=10 \
  --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
  --conf spark.sql.hive.verifyPartitionPath=true \
  --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
  --master yarn --deploy-mode cluster --name AdnAdxDeviceTag --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 32 \
  ../${JAR} -outputadxdevtag ${OUTPUT_ADN_ADX_DEVICE_TAG_PATH} \
  -coalesce 80 \
  -today ${dt_today} -yesterday ${dt_yesterday}


if [ $? -ne 0 ];then
  exit 255
fi



mount_partition "adn_adx_device_tag" "dt='${dt_today}'" "${OUTPUT_ADN_ADX_DEVICE_TAG_PATH}"

hadoop fs -touchz ${OUTPUT_ADN_ADX_DEVICE_TAG_PATH}/_SUCCESS
