#!/usr/bin/env bash


source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")

dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
last_req_day=$(date -d "$ScheduleTime 180 days ago" +"%Y-%m-%d")
dt_dash_rec14day=$(date -d "$ScheduleTime 15 days ago" +"%Y-%m-%d")


ALI_OUTPUT_DAILY_PATH="${ALI_USER_ACTIVATION_DAILY_PATH}/${dt_slash_today}"
OUTPUT_PATH="${ALI_USER_ACTIVATION_15DAYS_PATH}/${dt_slash_today}"

expire_date=$(date -d "$ScheduleTime 91 days ago" +"%Y%m%d")
expire_date_path=$(date -d "$ScheduleTime 91 days ago" +"%Y/%m/%d")
EXPIRE_PATH="${ALI_USER_ACTIVATION_15DAYS_PATH}/${expire_date_path}"

check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/adn_request/_SUCCESS"
check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/dsp_req/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH"
hadoop fs -rm -r "$ALI_OUTPUT_DAILY_PATH"
hadoop fs -rm -r "${REQUEST_COUNT_RESULT}/${dt_today}"

spark-submit --class mobvista.dmp.datasource.taobao.EtlAliActivitionDaily \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2200 \
 --conf spark.sql.shuffle.partitions=2200 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.yarn.executor.memoryOverhead=4096 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --master yarn --deploy-mode cluster  --executor-memory 10g --driver-memory 4g  --executor-cores 4  --num-executors 60 \
 ../../${JAR} -output ${OUTPUT_PATH} -outputdaily ${ALI_OUTPUT_DAILY_PATH} -coalesce 500 \
 -yesterday ${yesterday} -today ${dt_today}  -dt_dash_today ${dt_dash_today} -dt_dash_rec14day ${dt_dash_rec14day} \
 -request_count_result "${REQUEST_COUNT_RESULT}/${dt_today}" -last_req_day ${last_req_day}


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "ali_user_activation_daily" "dt='${dt_today}'" "$ALI_OUTPUT_DAILY_PATH"
mount_partition "ali_user_activation_rec15days" "dt='${dt_today}'" "$OUTPUT_PATH"

unmount_partition "ali_user_activation_rec15days" "dt='${expire_date}'" "$EXPIRE_PATH"


# hadoop fs -text $ALI_OUTPUT_DAILY_PATH/* > ali_userinfo_activation.csv
# split -b 900m  ali_userinfo_activation.csv  -d -a 3 imei.${dt}.


###  数据上传到oss文件系统

hadoop fs -touchz $ALI_OUTPUT_DAILY_PATH/_SUCCESS
hadoop fs -touchz $OUTPUT_PATH/_SUCCESS
