#!/usr/bin/env bash

source ../../dmp_env.sh

dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")

dt_two_days_ago=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
ALI_USER_TO_3S_TOUTIAO_RES_PATH="${ALI_USERINFO_TO_3S_TOUTIAO_PATH}/${dt_two_days_ago}"

#all
ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_0"

ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_1"

ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_2"

ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_3"

ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_4"

ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_5"

ALI_OAID_0_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_0"

ALI_OAID_1_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_1"

ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_2"

ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_3"

which hive
export HIVE_CONF_DIR=/data/azkaban-hadoop/command-home/hive-offline/conf
which hive

partition_info="day='${dt_today}', category='uc_lahuo', business='oaid_3'"
while [[ true ]];
do
#    if hive -e  "desc extended dwh.gdt_data partition($partition_info);"
    if hadoop fs -test -e "${ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH}/_SUCCESS"
    then
          echo  "good good study"
          break
    fi
  sleep 300
done


rm -rf totiao_H_22_H_31
mkdir totiao_H_22_H_31
cd totiao_H_22_H_31
#推头条数据
hadoop fs -test -e ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
fi

#H_22_imeimd5
hadoop fs -text  ${ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_22_imei_
for new_path in $(ls H_22_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

hadoop fs -text  ${ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_23_imei_
for new_path in $(ls H_23_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

hadoop fs -text  ${ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_24_imei_
for new_path in $(ls H_24_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

hadoop fs -text  ${ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_25_imei_
for new_path in $(ls H_25_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

hadoop fs -text  ${ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_26_imei_
for new_path in $(ls H_26_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

hadoop fs -text  ${ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_27_imei_
for new_path in $(ls H_27_imei_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv

#H_28_oaidmd5
hadoop fs -text  ${ALI_OAID_0_UC_LAHUO_SYS_TO3S_PATH}/* > oaidmd5.totiaocsv
split -b 55m  oaidmd5.totiaocsv  -d -a 2 H_28_oaidmd5_
for new_path in $(ls H_28_oaidmd5_*)
do
   echo ${new_path}
   device_id="oaidmd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f oaidmd5.totiaocsv

hadoop fs -text  ${ALI_OAID_1_UC_LAHUO_SYS_TO3S_PATH}/* > oaidmd5.totiaocsv
split -b 55m  oaidmd5.totiaocsv  -d -a 2 H_29_oaidmd5_
for new_path in $(ls H_29_oaidmd5_*)
do
   echo ${new_path}
   device_id="oaidmd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f oaidmd5.totiaocsv

hadoop fs -text  ${ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH}/* > oaidmd5.totiaocsv
split -b 55m  oaidmd5.totiaocsv  -d -a 2 H_30_oaidmd5_
for new_path in $(ls H_30_oaidmd5_*)
do
   echo ${new_path}
   device_id="oaidmd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f oaidmd5.totiaocsv

hadoop fs -text  ${ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH}/* > oaidmd5.totiaocsv
split -b 55m  oaidmd5.totiaocsv  -d -a 2 H_31_oaidmd5_
for new_path in $(ls H_31_oaidmd5_*)
do
   echo ${new_path}
   device_id="oaidmd5"
   echo $device_id
   java -cp ../../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f oaidmd5.totiaocsv


hadoop fs -touchz ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/_SUCCESS
rm -rf totiao_H_22_H_31