set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;
set hive.jobname.length=100;

insert overwrite table dwh.dm_install_list_v2 partition(dt='${dt_today}',business)
     select device_id,
     device_type,
     platform,
     package_name,
     '${update_date}' update_date,
     ali_type business
     from dwh.etl_ali_user_activation_total lateral view explode(split(packagename,',')) r1 AS package_name where dt ='${dt_today}'
     UNION
      select device_id,
     device_type,
     platform,
     package_name,
     '${update_date}' update_date,
     ali_type business
     from dwh.etl_ali_ios_user_activation_total lateral view explode(split(packagename,',')) r1 AS package_name where dt ='${dt_today}';


insert into table dwh.dm_install_list_v2 partition(dt='${dt_today}',business)
     select device_id,
     device_type,
     platform,
     package_name,
     '${update_date}' update_date,
     ali_type business
     from dwh.etl_ali_oaid_user_activation_total lateral view explode(split(packagename,',')) r1 AS package_name where dt ='${dt_today}';


insert overwrite table dwh.ods_dmp_user_info partition(dt='${dt_today}',business)
 select device_id,
     device_type,
     platform,
      'CN' country,
      '' age,
      '' gender,
      '' tags,
      '${update_date}' first_req_day,
      '${update_date}' last_req_day,
     ali_type business
     from dwh.etl_ali_user_activation_total where dt ='${dt_today}'
     UNION
  select device_id,
     device_type,
     platform,
      'CN' country,
      '' age,
      '' gender,
      '' tags,
      '${update_date}' first_req_day,
      '${update_date}' last_req_day,
     ali_type business
     from dwh.etl_ali_ios_user_activation_total where dt ='${dt_today}';


insert into table dwh.ods_dmp_user_info partition(dt='${dt_today}',business)
 select device_id,
     device_type,
     platform,
      'CN' country,
      '' age,
      '' gender,
      '' tags,
      '${update_date}' first_req_day,
      '${update_date}' last_req_day,
     ali_type business
     from dwh.etl_ali_oaid_user_activation_total where dt ='${dt_today}';



