#!/usr/bin/env bash

source ../../dmp_env.sh

dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")


#all
LAXIN_0_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_0"

LAXIN_1_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_1"

LAXIN_2_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/laxin_2"

LAHUO_0_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_0"

LAHUO_1_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_1"

LAHUO_2_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_2"

LAHUO_3_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_3"

LAHUO_4_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_4"

LAHUO_5_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin/lahuo_5"



rm -rf alipay_guangdiantong
mkdir alipay_guangdiantong
cd alipay_guangdiantong

ALI_USERINFO_TO_3S_ALIPAY_RES_PATH="${ALI_USERINFO_TO_3S_ALIPAY_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}"
#支付宝拉新拉活数据推广点通
hadoop fs -test -e ${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}
fi

#laxin
hadoop fs -text  ${LAXIN_0_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_0_HASH_IMEI_
for new_path in $(ls ALIPAY_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAXIN_1_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_1_HASH_IMEI_
for new_path in $(ls ALIPAY_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAXIN_2_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_2_HASH_IMEI_
for new_path in $(ls ALIPAY_2_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv


#lahuo
hadoop fs -text  ${LAHUO_0_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_3_HASH_IMEI_
for new_path in $(ls ALIPAY_3_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_1_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_4_HASH_IMEI_
for new_path in $(ls ALIPAY_4_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_2_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_5_HASH_IMEI_
for new_path in $(ls ALIPAY_5_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_3_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_6_HASH_IMEI_
for new_path in $(ls ALIPAY_6_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_4_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_7_HASH_IMEI_
for new_path in $(ls ALIPAY_7_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_5_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_8_HASH_IMEI_
for new_path in $(ls ALIPAY_8_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv


hadoop fs -touchz ${ALI_USERINFO_TO_3S_ALIPAY_RES_PATH}/_SUCCESS

rm -rf alipay_guangdiantong
echo "good job~~"


