#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : jiangfan
# @date : 2021-07-01 12:06:00
# # # # # # # # # # # # # # # # # # # # # #
#!/usr/bin/env bash

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

INPUT_PATH="${ODS_DMP_USER_INFO_DAILY}/${dt_today}"

check_await  "${INPUT_PATH}/_SUCCESS"

OUTPUT_PATH="${REYUN_LABEL_TEST_DAILY_PATH}/${dt_slash_today}"

hadoop fs -rm -r "${OUTPUT_PATH}"

spark-submit --class mobvista.dmp.datasource.reyun.ReyunLabelTest \
 --conf spark.network.timeout=720s \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --master yarn --deploy-mode cluster  --executor-memory 6g --driver-memory 4g  --executor-cores 3  --num-executors 40 \
 ../../${JAR}  \
 -output ${OUTPUT_PATH} -coalesce 40  -dt_today ${dt_today}

if [[ $? -ne 0 ]];then
  exit 255
fi

