#!/usr/bin/env bash

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
last_req_day=$(date -d "$ScheduleTime 7 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

UC_IMEIMD5_OUTPUT_PATH="${UC_LAHUO_DAILY_PATH}/${dt_slash_today}/imeimd5_request_data"
UC_OAIDMD5_OUTPUT_PATH="${UC_LAHUO_DAILY_PATH}/${dt_slash_today}/oaidmd5_request_data"


check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/adn_request/_SUCCESS"
check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/dsp_req/_SUCCESS"

hadoop fs -rm -r "${UC_IMEIMD5_OUTPUT_PATH}"
hadoop fs -rm -r "${UC_OAIDMD5_OUTPUT_PATH}"


spark-submit --class mobvista.dmp.datasource.taobao.UCLaHuoDaily \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.yarn.executor.memoryOverhead=4096 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 80 ../../${JAR} \
 -imeioutput "${UC_IMEIMD5_OUTPUT_PATH}"  -oaidoutput "${UC_OAIDMD5_OUTPUT_PATH}"  \
 -today ${dt_today}  -last_req_day ${last_req_day}

if [ $? -ne 0 ];then
  exit 255
fi
