#!/usr/bin/env bash

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
last_req_day=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

dt_slash_one_day=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_slash_two_day=$(date -d "$ScheduleTime 3 days ago" +"%Y/%m/%d")
dt_slash_three_day=$(date -d "$ScheduleTime 4 days ago" +"%Y/%m/%d")

INPUT_ONE_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_one_day}/imeimd5_request_data"
INPUT_TWO_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_two_day}/imeimd5_request_data"
INPUT_THREE_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_three_day}/imeimd5_request_data"

OAID_INPUT_ONE_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_one_day}/oaidmd5_request_data"
OAID_INPUT_TWO_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_two_day}/oaidmd5_request_data"
OAID_INPUT_THREE_DAY="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_three_day}/oaidmd5_request_data"

YOUKU_IMEIMD5_OUTPUT_PATH="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_today}/imeimd5_request_data"
YOUKU_OAIDMD5_OUTPUT_PATH="${YOUKU_LAXIN_DAILY_PATH}/${dt_slash_today}/oaidmd5_request_data"

check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/adn_request/_SUCCESS"
check_await "${ODS_DMP_USER_INFO}/${dt_slash_today}/dsp_req/_SUCCESS"

hadoop fs -rm -r "${YOUKU_IMEIMD5_OUTPUT_PATH}"
hadoop fs -rm -r "${YOUKU_OAIDMD5_OUTPUT_PATH}"


spark-submit --class mobvista.dmp.datasource.taobao.YOUKULaXinDaily \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.yarn.executor.memoryOverhead=4096 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 80 ../../${JAR} \
 -imeioutput "${YOUKU_IMEIMD5_OUTPUT_PATH}"  -oaidoutput "${YOUKU_OAIDMD5_OUTPUT_PATH}"  \
 -input_one_day ${INPUT_ONE_DAY}  -input_two_day ${INPUT_TWO_DAY}  -input_three_day ${INPUT_THREE_DAY} \
 -oaid_input_one_day ${OAID_INPUT_ONE_DAY}  -oaid_input_two_day ${OAID_INPUT_TWO_DAY}  -oaid_input_three_day ${OAID_INPUT_THREE_DAY} \
 -today ${dt_today}  -last_req_day ${last_req_day}

if [ $? -ne 0 ];then
  exit 255
fi
