#!/usr/bin/env bash


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_three_days_ago=$(date -d "$ScheduleTime 3 days ago" +"%Y-%m-%d")

IMEIMD5_OUTPUT_PATH="${YOUKU_LAXIN_DAILY_TMP_PATH}/$date_path/imeimd5"
OAIDMD5_OUTPUT_PATH="${YOUKU_LAXIN_DAILY_TMP_PATH}/$date_path/oaidmd5"

hadoop fs -rm -r "${IMEIMD5_OUTPUT_PATH}"
hadoop fs -rm -r "${OAIDMD5_OUTPUT_PATH}"

spark-submit --class mobvista.dmp.datasource.taobao.YOUKULaxinDF \
     --name "YOUKULaxinDF.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 3  --num-executors 10 \
     ../../${JAR} -date ${LOG_TIME} -dt_three_days_ago ${dt_three_days_ago} -partNum 10 -imeiOutput ${IMEIMD5_OUTPUT_PATH}  -oaidOutput ${OAIDMD5_OUTPUT_PATH}  -cluster 'cluster_1st'

if [[ $? -ne 0 ]];then
  exit 255
fi